-----------------------------------------------------------------------------------------
--AG: 19.05.2006
--    -   b_soldier
--   (  ,       .          . .)
--     "squaddy"
--      "squad_leader"
-- service    :
----getSquaddiesList 	-    ( -.   id.)
----getSquadSize 		-    (  )
----closestSquaddy		-    (id)
--       ,     .
--  ,      . b_soldier.
-----------------------------------------------------------------------------------------

b_squad_leader = 
{
---------------------------------
--SOLDIER SQUAD LEADER BEHAVIOR--
---------------------------------
	think = function(id)
calls.enter("b_squad_leader.think",id)

		if(Humans[id].leaderTurnsForSkip==nil) then
			Humans[id].leaderTurnsForSkip = 0
		end

		if( (not healthOK(id)) or (Humans[id].leaderTurnsForSkip > 0)) then
calls.leave("b_squad_leader.think",id)
			return(false)
		end

		local ret = true
		local human = Humans[id]												--
		local squad_name = Humans[id].params										--  
		local closest_squaddy = service.closestSquaddy(id)				-- 
		local squaddies = service.getSquaddiesList(id)					-- 
		local squad_size = table.getn(squaddies)
		local closest_dangerous_target = service.closestDangerousEnemy(id)		--  
		local closest_visible_target = service.closestVisibleEnemy(id)			--  
		local allowable_causalties_percent = getAIConst().leaderAllowDiedProb		--          
		local causalties_percent = 1							--    
		local exit = false
		memory.cleanKnownEnemies(id)
		local closest_known_target = memory.getClosestKnownEnemy(id)

		if(not isValid(human.squad)) then
		--      -   
			log(id, "======================")
			log(id, "<<I'm a Squad Leader>>")
			log(id, "----------------------")
			log(id, "My squad is:", squad_name)
			log(id, "There are", squad_size, "squaddies")
			log(id, "Closest is:", closest_squaddy)
			log(id, "Squaddies' names:")
	
			for count = 1, squad_size, 1 do
				current = squaddies[count]
				log(id, count..". ", current)
				if(not isUnitValid(Humans[current].leader)) then
					Humans[current].leader = id
				elseif (Humans[current].leader ~= id) then
					log(id, "There's already a leader:", Humans[current].leader)
					log(id, "Changing my status to squaddy")
					Humans[id].behavior = "squaddy"
					Humans[id].params = Humans[Humans[current].leader].params
					Humans[id].leader = Humans[current].leader
					exit = true
					break
				end
			end

			log(id, "======================")
			
			if (exit == true) then
calls.leave("b_squad_leader.think",id)
				return(true)
			end

			Humans[id].squad = squad_name
			Humans[id].initial_squad_size = squad_size
		else
		--    
			log(id, "======================")
			log(id, "<<I'm a Squad Leader>>")
			log(id, "======================")
		end

		if (squad_size < Humans[id].initial_squad_size) then
		-- 
			local causalties = Humans[id].initial_squad_size - squad_size
			log(id, " ", causalties, "")
			causalties_percent = 1 - causalties / Humans[id].initial_squad_size
		else
			log(id, "   ")
		end

		if (squad_size == 0) then
		-- 
			log(id, " .    SQUAD_LEADER  PATROL")
			Humans[id].behavior = "free"
			Humans[id].retreat = false
calls.leave("b_squad_leader.think",id)
			return(false)
		end
		
		if(causalties_percent > allowable_causalties_percent) then
		--  
			log(id, " :", causalties_percent)
			local orderTo = NONE

			for count = 1, squad_size, 1 do
				local orderToBe = squaddies[count]
				local closest_v = service.closestVisibleEnemy(orderToBe)

				if(isUnitValid(Humans[orderToBe].assigned_target) and (not IsAlive(Humans[orderToBe].assigned_target))) then
					log(id, orderToBe, "  ")
					Humans[orderToBe].assigned_target = NONE
				end

				if((not isUnitValid(closest_v)) and (not isUnitValid(Humans[orderToBe].assigned_target))) then
				--           
					local dist = service.person2person_distance(id, orderToBe)
					if (dist < getAIConst().leaderMaxCmdDist) then
						log(id, orderToBe, ".")
						orderTo = orderToBe
						log(id, "   ", orderTo)
						break
					else
						log(id, orderToBe, " .")
					end

				elseif(isUnitValid(closest_v) and (not isUnitValid(Humans[orderToBe].assigned_target))) then
					log(id, orderToBe, "   .     .")
					Humans[orderToBe].assigned_target = closest_v
				elseif((not isUnitValid(closest_v)) and isUnitValid(Humans[orderToBe].assigned_target)) then
					log(id, orderToBe, " .     .")
				else
					log(id, orderToBe, "  .      ,  .")

					if (closest_v == Humans[orderToBe].assigned_target) then
						log(id, ",      .   .")
					else
						if(service.isTargetDangerous(closest_v)) then
							local rnd = math.random()
							log(id, "  !")
							if(service.isTargetDangerous(Humans[orderToBe].assigned_target)) then
								log(id, "  !   !")
								if (rnd > 0.25) then
									Humans[orderToBe].assigned_target = closest_v
									log(id, "  !")
								else
									log(id, "    !    !")
								end

							else
								log(id, "   .")
								if (rnd > 0.85) then
									log(id, "  .    !")
								else
									log(id, "    .")
									Humans[orderToBe].assigned_target = closest_v
								end
							end
						else
							log(id, "    !")
							local rnd = math.random()

							if (service.isTargetDangerous(Humans[orderToBe].assigned_target) == true) then
								log(id, "   .")

								if (rnd > 0.85) then
									Humans[orderToBe].assigned_target = closest_v
									log(id, "  !   !")
								else
									log(id, "     ")
								end
								
							else
								log(id, "    !")

								if (rnd > 0.5) then
									log(id, "   .")
									Humans[orderToBe].assigned_target = closest_v
								else
									log(id, ",     .")
								end
							end
						end
					end
				end

			end

			if(isUnitValid(orderTo)) then
			--  
			--TODO:  .
				if(isUnitValid(closest_visible_target)) then
				--   
					log(id, "  . :", closest_visible_target)

					if(not isUnitValid(closest_dangerous_target)) then
					--   
						log(id, "  :", closest_visible_target)
						Humans[orderTo].assigned_target = closest_visible_target
						service.alertSquad(id, "YELLOW")
					else
					--   
						log(id, "  :", closest_dangerous_target)
						Humans[orderTo].assigned_target = closest_dangerous_target
						service.alertSquad(id, "RED")
					end
				elseif (closest_known_target ~= nil) then
				--    
					log(id, "  ")
					log(id, "  . :", closest_known_target.id)
					service.alertSquad(id, "YELLOW")
					log(id, "  :", closest_known_target.id)
					Humans[orderTo].assigned_target = closest_known_target.id
				else
				--   
					log(id, " ")
					Humans[id].leaderTurnsForSkip = 1
					local rnd = math.random()
					if (Humans[id].status == "RED") then
						if (rnd < 0.50) then
							service.alertSquad(id, "YELLOW")
						end
					elseif (Humans[id].status == "YELLOW") then
						if (rnd < 0.25) then
							service.alertSquad(id, "GREEN")
						end
					end
					ret = false
				end
			else
				log(id, "    ")
				Humans[id].leaderTurnsForSkip = 1
				ret = false
			end
		else
			log(id, " .  :", causalties_percent)
			local rnd 			= math.random()
			local remark_rnd 	= math.random()
			local count 		= math.random(5)
			local remark 		= "leader_retreat_0"
			--TODO: morale check

			local morale = getPersonParameter(id, "MORALE")
			log(id,"morale:",morale)
			local rnd_threshold = getAIConst().leaderRetreatProb
			log(id,"rnd_threshold without morale",rnd_threshold)
			rnd_threshold = rnd_threshold*100/morale
			log(id,"rnd_threshold with morale",rnd_threshold)


			if((rnd < rnd_threshold) and (not Humans[id].retreat)) then
				log(id, "RETREAT!!")
				Humans[id].retreat = true
				for count = 1, squad_size, 1 do
					local current = squaddies[count]
					Humans[current].retreat = true
				end
				Humans[id].leaderTurnsForSkip = getAIConst().leaderRetreatTurns
			else
				-- ,  .    .
				log(id, "!     . :", squad_size, ":", Humans[id].initial_squad_size)
				Humans[id].initial_squad_size = squad_size
				if(human.retreat) then
					Humans[id].retreat = false
					remark = "leader_regroup_0"
					for count = 1, squad_size, 1 do
						local current = squaddies[count]
						Humans[current].retreat = false
					end
				else
					remark = "leader_hold_0"
				end
				Humans[id].leaderTurnsForSkip = 1
			end
			service.showAck(id,remark..count,0.5,1)
--			if(Humans[id].retreat and
--				(relations(team(id),PLAYER)==ENEMY)) then
--				local merc = service.visibleByWhom(id,CUR_MISSION.Mercs)
--				if(isUnitValid(merc)) then
--					local count = math.random(2)
--					service.showAck(merc,merc.."_enemy_retreat_0"..count,0.5)
--				end
--			end
		end
calls.leave("b_squad_leader.think",id)
		return(ret)
	end,
}